function NavObjective()
{
	this.title = null;
	this.description = null;
	this.id = null;
	this.satisfied = null;
	this.score = null; // range = [0,100]
	this.events = null;
	
	this.setDefaultValues();
}
NavObjective.prototype.loadFromXMLNode = NavObjectiveLoadFromXMLNode;
NavObjective.prototype.setDefaultValues = NavObjectiveSetDefaultValues;
NavObjective.prototype.toString = NavObjectiveToString;
NavObjective.prototype.setSatisfied = NavObjectiveSetSatisfied;
NavObjective.prototype.getSatisfied = NavObjectiveGetSatisfied;
NavObjective.prototype.setScore = NavObjectiveSetScore;
NavObjective.prototype.getScore = NavObjectiveGetScore;
NavObjective.prototype.registerEvent = RegisterEvent;

function NavObjectiveSetScore(score)
{
	if (score > 100) score = 100;
	else if (score < -100) score = -100;
	if (this.score != score)
	{
		this.score = score;
		this.events.raiseEvent("score", this);
	}
}

function NavObjectiveGetScore(score)
{
	return this.score;
}

function NavObjectiveSetSatisfied(flag)
{
	if (this.satisfied != flag)
	{
		this.satisfied = flag;
		this.events.raiseEvent("satisfied", this);
	}
}

function NavObjectiveGetSatisfied()
{
	return this.satisfied;
}

function NavObjectiveToString()
{
	return "[Objective: id=\"" + this.id + "\" satisfied=\"" + this.satisfied + "\" score=\"" + this.score +"\"]";
}

function NavObjectiveSetDefaultValues()
{
	this.id = "";
	this.title = "";
	this.description = "";
	this.satisfied = false;
	this.score = 0;
	this.events = new EventsObject(DEFAULT_OBJECTIVE_EVENTS);
}

function NavObjectiveLoadFromXMLNode(xmlNode)
{
	this.setDefaultValues();
	this.id = xmlNode.getAttribute("id").toLowerCase();
	this.title = xmlNode.getAttribute("title");

	var descriptionNode = (xmlNode.getElements("description"))[0];
	if (descriptionNode != null)
	{
		this.description = descriptionNode.getText();
	}
}
